package Polynome;

public class Polynome {

	private Monome[] tabMonome;
	
	public Polynome (int ordre) {
		if (ordre<0)
			ordre = 3;
		tabMonome = new Monome[ordre];
		for (int i=0; i<ordre; i++)
			tabMonome[i] = new Monome(0,i);
	}
	
	public void addMonome(Monome M)
	{
		if ( M.getDegre() >= tabMonome.length)
			System.out.println("Degr� du monome non valide!");
		else
			tabMonome[M.getDegre()].addMonomeMemeDegre (M.getCoeff());
	}

	@Override
	public String toString() {
		//return "Polynome [tabMonome=" + Arrays.toString(tabMonome) + "]";
		String S = " ";
		for (int i=0; i<tabMonome.length; i++)
			S+=tabMonome[i].toString();
		return S;
	}
	
	public double polyEval(double x) {
		double val = 0.;
		
		for(int i=0; i<tabMonome.length; i++)
			val += tabMonome[i].getCoeff() * Math.pow(x, tabMonome[i].getDegre());
		
		return val;
	}
	
	public Polynome getPolyDeriv() {
		Polynome Q = new Polynome(tabMonome.length-1);
		for(int i=0; i<tabMonome.length-1; i++) {
			Monome aAjouter = new Monome(tabMonome[i+1].getCoeff()*tabMonome[i+1].getDegre(), i);
			Q.addMonome(aAjouter);
		}
		return Q;
		
	}
}
